<?php
/* --------------------------------------------------------------
   LanguageNotFoundException.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language\Exceptions;

use Exception;
use Gambio\Core\Language\LanguageCode;
use Gambio\Core\Language\LanguageId;

/**
 * Class LanguageNotFoundException
 *
 * @package Gambio\Core\Language\Exceptions
 */
class LanguageNotFoundException extends Exception
{
    /**
     * @param LanguageId $id
     *
     * @return LanguageNotFoundException
     */
    public static function createForId(LanguageId $id): LanguageNotFoundException
    {
        return new self('Language with ID "' . $id->value() . '" does not exist.');
    }
    
    
    /**
     * @param LanguageCode $code
     *
     * @return LanguageNotFoundException
     */
    public static function createForCode(LanguageCode $code): LanguageNotFoundException
    {
        return new self('Language with code "' . $code->value() . '" does not exist.');
    }
}